#!/bin/bash
# ===========================================================================
#    Automated script generated by the CSB server for Arctic3D execution
# ===========================================================================
# September 29, 2023 13:36:02 UTC
# ===========================================================================
# ===========================================================================
outputfile="output.out"

echo "# ===========================================================================" &>> $outputfile
log="arctic3d.log"

cmd="arctic3d --full P63165"












cmd+=" --threshold 0.866"



cmd+=" --linkage_strategy average"





cmd+=" --int_cov_cutoff 0.7"


echo "command: $cmd" &>> $outputfile
$cmd &> $log

status=$?
echo "exit status: $status" &>> $outputfile
echo "log:" &>> $outputfile
cat $log >> $outputfile

if [ $status -eq 255 ]; then
  #  This is a special case where the program is not able to find any
  #  interface for the given protein. In this case, we just exit with
  #  status 0 and do not run the localisation step.
  echo "No interfaces found, exiting with status 0"
  exit 0
fi


cmd="arctic3d-localise arctic3d-P63165/clustered_interfaces.out --quickgo=C --run_dir arctic3d-localise-subcellular"
$cmd &> $log

status=$?
echo "exit status: $status" &>> $outputfile
echo "log:" &>> $outputfile
cat $log >> $outputfile



cmd="arctic3d-localise arctic3d-P63165/clustered_interfaces.out --quickgo=F --run_dir arctic3d-localise-proteinfunction"
$cmd &> $log

status=$?
echo "exit status: $status" &>> $outputfile
echo "log:" &>> $outputfile
cat $log >> $outputfile



cmd="arctic3d-localise arctic3d-P63165/clustered_interfaces.out --quickgo=P --run_dir arctic3d-localise-biologicalprocess"
$cmd &> $log

status=$?
echo "exit status: $status" &>> $outputfile
echo "log:" &>> $outputfile
cat $log >> $outputfile


mv arctic3d-P63165/* . > /dev/null 2>&1

exit $status
# ===========================================================================