#!/bin/bash
# ===========================================================================
#    Automated script generated by the CSB server for Whiscy execution
# ===========================================================================
# 2023-05-24 15:14:37.652287
# ===========================================================================
# ===========================================================================
outputfile="output.out"

echo "# ===========================================================================" &>>$outputfile
log="whiscy.log"

# Setup
cmd="/opt/software/whiscy/whiscy_setup.py 1ppe E"
echo "command: $cmd" &>>$outputfile
$cmd &>>$log
status=$?
echo "exit status: $status" &>>$outputfile
echo "log:" &>>$outputfile
cat $log >>$outputfile
if [ $status -ne 0 ]; then
	exit $status
fi

# Run
cmd="/opt/software/whiscy/whiscy_protocol.sh 1ppe_E"
echo "command: $cmd" &>>$outputfile
$cmd &>>$log
status=$?
echo "exit status: $status" &>>$outputfile
echo "log:" &>>$outputfile
cat $log >>$outputfile
if [ $status -ne 0 ]; then
	exit $status
fi

conservation_file="1ppe_E.pscons"

# B-factor
cmd="/opt/software/whiscy/bin/whiscy2bfactor.py 1ppe_E.pdb 1ppe_E_bfactor.pdb ${conservation_file}"
echo "command: $cmd" &>>$outputfile
$cmd &>>$log
status=$?
echo "exit status: $status" &>>$outputfile
echo "log:" &>>$outputfile
cat $log >>$outputfile
if [ $status -ne 0 ]; then
	exit $status
fi

# Haddock
cmd="/opt/software/whiscy/bin/whiscy2haddock.py 1ppe_E.pdb 1ppe_E_haddock.pdb ${conservation_file}"
echo "command: $cmd" &>>$outputfile
$cmd &>>$log
status=$?
echo "exit status: $status" &>>$outputfile
echo "log:" &>>$outputfile
cat $log >>$outputfile
if [ $status -ne 0 ]; then
	exit $status
fi

# Compress whole directory into a zip file
cmd="zip -r whiscy.zip ."
echo "command: $cmd" &>>$outputfile
$cmd &>>$log
status=$?
echo "exit status: $status" &>>$outputfile
echo "log:" &>>$outputfile
cat $log >>$outputfile
if [ $status -ne 0 ]; then
	exit $status
fi

exit $status
# ===========================================================================
